<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code


/**
 * Used to the judocup app
 */
defined('BASE_URL') OR define('BASE_URL','http://localhost/judocup/');
defined('DEFUALT_LANGUAGE') OR define('DEFAULT_LANGUAGE','spanish');
defined('URL_ASSETS') OR define('URL_ASSETS','http://localhost/TFG/judocup/');


/**
 *  Error messages
 */

defined('ERROR_ENTER_EMAIL_OR_PASSWORD') OR define('ERROR_ENTER_EMAIL_OR_PASSWORD',1);
defined ('RECOVERY_PASSWORD_SENT') OR define('RECOVERY_PASSWORD_SENT',2);
defined ('SUCCESFULL_CHANGE_PASSWORD') OR define('SUCCESFULL_CHANGE_PASSWORD',3);
defined ('ERROR_TEAM_EXISTS') OR define('ERROR_TEAM_EXISTS',4);
defined ('SUCCESS_CREATE_TEAM') OR define('SUCCESS_CREATE_TEAM',5);
defined ('SUCCESS_DELETE_TEAM') OR define('SUCCESS_DELETE_TEAM',6);
defined ('ERROR_DELETE_TEAM') OR define('ERROR_DELETE_TEAM',7);
defined ('SUCCESS_UPDATE_TEAM') OR define('SUCCESS_UPDATE_TEAM',8);
defined ('ERROR_UPDATE_TEAM') OR define('ERROR_UPDATE_TEAM',9);

defined ('ERROR_DNI_EXISTS') OR define('ERROR_DNI_EXISTS',10);

defined ('ERROR_CREATE_REFEREE') OR define('ERROR_CREATE_REFEREE',11);
defined ('SUCCESS_CREATE_REFEREE') OR define('SUCCESS_CREATE_REFEREE',12);

defined ('SUCCESS_DELETE_REFEREE') OR define('SUCCESS_DELETE_REFEREE',13);
defined ('ERROR_DELETE_REFEREE') OR define('ERROR_DELETE_REFEREE',14);

defined ('SUCCESS_UPDATE_REFEREE') OR define('SUCCESS_UPDATE_REFEREE',15);
defined ('ERROR_UPDATE_REFEREE') OR define('ERROR_UPDATE_REFEREE',16);

defined ('ERROR_OLD_PASSWORD') OR define('ERROR_OLD_PASSWORD',17);
defined ('SUCCESS_CREATE_COMPETITION') OR define('SUCCESS_CREATE_COMPETITION',18);
defined ('ERROR_CREATE_COMPETITION') OR define('ERROR_CREATE_COMPETITION',19);

defined ('SUCCESS_DELETE_COMPETITION') OR define('SUCCESS_DELETE_COMPETITION',20);
defined ('ERROR_DELETE_COMPETITION') OR define('ERROR_DELETE_COMPETITION',21);

defined ('SUCCESS_ADD_REFEREE_TO_COMPETITION') OR define('SUCCESS_ADD_REFEREE_TO_COMPETITION',22);
defined ('ERROR_ADD_REFEREE_TO_COMPETITION') OR define('ERROR_ADD_REFEREE_TO_COMPETITION',23);

defined ('SUCCESS_DELETE_REFEREE_INSCRIPTION') OR define('SUCCESS_DELETE_REFEREE_INSCRIPTION',24);
defined ('ERROR_DELETE_REFEREE_INSCRIPTION') OR define('ERROR_DELETE_REFEREE_INSCRIPTION',25);

defined('SESSION_EXPIRED') OR define('SESSION_EXPIRED',26);
defined('EXISTS_COMPETITOR_NAME_SURNAME') OR define('EXISTS_COMPETITOR_NAME_SURNAME',27);
defined('SUCCESS_COMPETITOR_INSCRIPTION') OR define('SUCCESS_COMPETITOR_INSCRIPTION',28);
defined('EXISTS_INSCRIPTION') OR define('EXISTS_INSCRIPTION',29);
defined('ERROR_COMPETITON_EXISTS') OR define('ERROR_COMPETITION_EXISTS',30);
defined('SUCCESS_DELETE_COMPETITOR_PARTICIPATION') OR define('SUCCESS_DELETE_COMPETITOR_PARTICIPATION',31);
defined('LOAD_MODAL_CREATE_REFEREE_CATEGORY') OR define('LOAD_MODAL_CREATE_REFEREE_CATEGORY',32);
defined('SUCCESS_ADD_REFEREE_CATEGORY') OR define('SUCCESS_ADD_REFEREE_CATEGORY',33);

defined('ERROR_CREATE_TIMEKEEPER') OR define ('ERROR_CREATE_TIMEKEEPER',34);
defined('SUCCESS_CREATE_TIMEKEEPER') OR define ('SUCCESS_CREATE_TIMEKEEPER',35);

defined('SUCCESS_ADD_TIMEKEEPER_TO_MAT') OR define ('SUCCESS_ADD_TIMEKEEPER_TO_MAT',36);
defined('SUCCESS_DELETE_TIMEKEEPER_TO_MAT') OR define ('SUCCESS_DELETE_TIMEKEEPER_TO_MAT',37);
defined('ERROR_EQUAL_COMPETITOR') OR define ('ERROR_EQUAL_COMPETITOR',38);

defined('SUCCESS_CREATE_COMBAT') OR define ('SUCCESS_CREATE_COMBAT',39);
defined('SUCCESS_ADD_SCORE') OR define ('SUCCESS_ADD_SCORE',40);
defined('SUCCESS_UPDATE_MAT') OR define ('SUCCESS_UPDATE_MAT',41);

defined('SUCCESS_ENTER_POSITION') OR define ('SUCCESS_ENTER_POSITION',42);
defined('SUCCESS_DELETE_COMBAT') OR define ('SUCCESS_DELETE_COMBAT',43);

defined('ERROR_CAN_NOT_GENERATE_COMBATS') OR define ('ERROR_CAN_NOT_GENERATE_COMBATS',44);

defined('NO_SELECT_ALGORITHIM') OR define ('NO_SELECT_ALGORITHIM',45);

defined('SIZE_OF_DNI') OR define ('SIZE_OF_DNI',46);






